%! sched.pro -- PostScript prologue file to print schedules
%     Alan Nishioka     24 September 1987     cc-23@cory.berkeley.edu

/inch
{
    72 mul
} def

/hour 
{
    .75 inch mul
} def

/DayRowWidth .5 inch def
/TimeColumnWidth .5 inch def
/DayWidth 1.3 inch def
/DayPad 3 def

/centershow %string width -- center string within width leave point after width
{
    exch dup stringwidth pop 3 2 roll sub -2 div dup 3 1 roll 0 rmoveto show
        0 rmoveto
} def

1 setlinewidth

/Times-Roman findfont .20 inch scalefont setfont
.5 inch TimeColumnWidth add 9.45 inch DayRowWidth 2 div sub moveto
(Monday) DayWidth centershow
(Tuesday) DayWidth centershow
(Wednesday) DayWidth centershow
(Thursday) DayWidth centershow
(Friday) DayWidth centershow

/showtime % string -- shows time. leaves point 1 hour below original
{
    currentpoint 3 2 roll dup TimeColumnWidth centershow
    5 DayWidth mul 0 rmoveto TimeColumnWidth centershow
    moveto 0 -1 hour rmoveto
} def

.5 inch 9.5 inch .80 inch sub moveto
(8:00) showtime (9:00) showtime (10:00) showtime (11:00) showtime
(12:00) showtime (1:00) showtime (2:00) showtime (3:00) showtime
(4:00) showtime (5:00) showtime (6:00) showtime

% draw outermost line
newpath 0 setgray .5 inch 9.5 inch moveto
TimeColumnWidth 2 mul 5 DayWidth mul add dup dup 0 rlineto
0 -8.5 inch rlineto neg 0 rlineto closepath stroke
.5 inch 9 inch moveto 0 rlineto stroke % draw header line


% draw column lines
.5 inch 9.5 inch moveto TimeColumnWidth 0 rmoveto
8.5 inch 6 { neg dup 0 exch rlineto DayWidth 0 rmoveto } repeat stroke

/Times-Italic findfont 10 scalefont setfont
.5 inch .80 inch moveto 0 setgray
(Produced by Alan Nishioka and computer.  974 Tulare Avenue Albany CA 94707)
show

/mon .5 inch TimeColumnWidth add def
/tue mon DayWidth add def
/wed tue DayWidth add def
/thu wed DayWidth add def
/fri thu DayWidth add def

/BodyFontSize 10 def
/HeaderFontSize 30 def

/tintpri { % priority -> graylevel
    1 eq { .89 } { .99 } ifelse
} def

/shadebox  % priority, duration, day-of-week, time-start
{
        newpath	moveto
	dup 0 exch neg rlineto
	DayWidth 0 rlineto
        0 exch rlineto
	closepath
        tintpri setgray gsave fill
        grestore 0 setgray stroke
} def

/LineSpacing 2 def

/title % Class, Professor, Section, Room, Duration,
       % day-of-week, time-start
{
        moveto 0 setgray
	/Duration exch def
        /Room exch def
        /Section exch def
        /Professor exch def
        /Class exch def
        /Times-Bold findfont BodyFontSize scalefont setfont
        Duration 3 BodyFontSize LineSpacing add mul add -2 div
            DayPad exch rmoveto
	Professor show
	Professor stringwidth pop neg BodyFontSize LineSpacing add rmoveto
	Room show
	Room stringwidth pop neg BodyFontSize LineSpacing add rmoveto
	Class show
	DayWidth DayPad 2 mul sub Section stringwidth pop sub
            Class stringwidth pop sub 0 rmoveto
	Section show
} def
	
/PageWidth 8.5 inch def

/draw_header {
    /Header2 exch def
    /Header1 exch def
    /Times-Bold findfont HeaderFontSize scalefont setfont
    PageWidth Header1 stringwidth pop sub 2 div 10.2 inch moveto Header1 show
    PageWidth Header2 stringwidth pop sub 2 div 10.2 inch HeaderFontSize sub
	moveto Header2 show
} def

/fix_time { % time (ie. 8.0-6.0)
    8 sub dup 0 lt { 12 add } if
    hour neg 8.75 inch add 
} def

/entry { % class, professor, section, room
         % priority, duration, day-of-week, time-start
    fix_time 3 copy 7 3 roll shadebox title
} def

% Add class data after this line.

