/* tsend.c    Sends data stream to program and EPROM for use
	      with tiny LED display (Siemens 4 character) */

#include <stdio.h>

#define STRLEN 100
#define LENGTH 512

main( argc, argv )
    int argc;
    char **argv;
{
    int i, j;
    FILE *fin;
    FILE *fout;
    char string[ STRLEN ];

    if( argc != 3 ) {
        printf( "Usage: tsend infile outfile\n" );
        exit( 1 );
    }

    fin = fopen( argv[ 1 ], "r" );
    if( fin == NULL ) {
        printf( "Error opening %s.\n", argv[ 1 ] );
        exit( 1 );
    }

    fout = fopen( argv[ 2 ], "w" );
    if( fout == NULL ) {
        printf( "Error opening %s.\n", argv[ 2 ] );
        exit( 1 );
    }

    fprintf( fout, "    mi" );
    fprintf( fout, "p0000-" );			/* Start programming */

    fprintf( fout, "02 80 80 80 02 80 80 80\n" );  /* Display attributes */

    for( j = 0; j < LENGTH - 2; j += 1 ) {	/* Send display data */
        fgetstring( fin, string );
        for( i = 7; i >= 0; i -= 1 ) {
            if( strlen( string ) > i ) 
		fprintf( fout, "%02x ", 0x80 | string[ i ] );
            else fprintf( fout, "a0 " );
        }
        fprintf( fout, "\n" );
    }
    fprintf( fout, "00 00 00 00 00 00 00 00\n" );	/* Blank Display */
    fprintf( fout, "$\n" );			/* End programming */

    fclose( fout );
    fclose( fin );
}

fgetstring( fin, string )
    FILE *fin;
    char *string;
    /* Gets a string from fin, stopping at 8 characters or an \n and
       including spaces */
{
    int i, c;

    for( i = 0; i < 8; i += 1 ) {
        c = getc( fin );
        string[ i ] = c;
        if( c == '\n' ) break;
    }
    string[ i ] = '\0';
    while( c != EOF ) {		/* Discard through next \n */
        if( c == '\n' ) break;
        c = getc( fin );
    }
}
