#include <stdio.h>

#define WIDTH 240		/* Width and Height of LCD screen */
#define PADW 16			/* Width of padding on a line */
#define HEIGHT 64
#define MAXLEN 256		/* Maximum string length */
#define IBM

#include <bios.h>
#define SERIAL "COM2"
#define READ "rb"
#define WRITE "wb"

main()
{
    FILE *fp, *fd;
	int i, j;

    printf( "Downloading bitmap to LCD screen...\n" );

    bioscom( 0, 0xe0 | 0x03, 1 );
    fp = fopen( SERIAL, WRITE );

    putc( 0x30, fp );		/* Clear address counter */
    		 				/* Set latch to load mode */
 
    for( j = 0; j < HEIGHT; j += 1 ) {
	    putc( 0x20, fp );			/* One bit pre pad */
	    for( i = 0; i < WIDTH; i += 1 ) putc( 0x20 | ((i&0x0f)^0x00), fp );
	    for( i = 0; i < PADW - 1; i += 1 ) putc( 0x20, fp ); /* Post pad */
    }
    putc( 0, fp );			/* Clear latch to display mode */
    printf( "Done.\n" );
    fclose( fp );
}
